// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityBug.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityBug.h"
#include "Level.h"




EntityBug::EntityBug( Dobbs::EntityTypes EType ) 
{

  m_Type = EType;
  m_CanBeCarried    = true;

  m_DisplayOffset.x = 31;
  m_DisplayOffset.y = 27;

  SetRect( &m_CollisionRect, -31, -27, 31, 0 );

  if ( EType == Dobbs::ENTITY_TYPE_BUG_L )
  {
    SetFrame( Dobbs::ANIM_BUG_WALK_L );
  }
  else
  {
    SetFrame( Dobbs::ANIM_BUG_WALK_R );
  }

}



EntityBug::~EntityBug() 
{
}



void EntityBug::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_MOVED_LEFT:
      {
        RECT    rcTemp = CollisionRect();

        rcTemp.right = rcTemp.left;
        rcTemp.left--;
        rcTemp.top = rcTemp.bottom;
        rcTemp.bottom++;

        if ( !m_pLevel->IsAreaBlocked( this, rcTemp, Dobbs::DIR_FALL ) )
        {
          // could fall down, turn back
          Move( *m_pLevel, 1.0f, 0.0f, Dobbs::DIR_FORCED_MOVE );
          m_Type = Dobbs::ENTITY_TYPE_BUG_R;
          SetFrame( Dobbs::ANIM_BUG_WALK_R );
        }
      }
      break;
    case EE_MOVED_RIGHT:
      {
        RECT    rcTemp = CollisionRect();

        rcTemp.left = rcTemp.right;
        rcTemp.right++;
        rcTemp.top = rcTemp.bottom;
        rcTemp.bottom++;
        if ( !m_pLevel->IsAreaBlocked( this, rcTemp, Dobbs::DIR_FALL ) )
        {
          // could fall down, turn back
          Move( *m_pLevel, -1.0f, 0.0f, Dobbs::DIR_FORCED_MOVE );
          m_Type = Dobbs::ENTITY_TYPE_BUG_L;
          SetFrame( Dobbs::ANIM_BUG_WALK_L );
        }
      }
      break;
    case EE_BLOCKED_LEFT:
      m_Type = Dobbs::ENTITY_TYPE_BUG_R;
      SetFrame( Dobbs::ANIM_BUG_WALK_R );
      break;
    case EE_BLOCKED_RIGHT:
      m_Type = Dobbs::ENTITY_TYPE_BUG_L;
      SetFrame( Dobbs::ANIM_BUG_WALK_L );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityBug::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );
  if ( m_OnGround )
  {
    if ( m_Type == Dobbs::ENTITY_TYPE_BUG_L )
    {
      Move( aLevel, -120.0f * ElapsedTime, 0.0f, Dobbs::DIR_LEFT );
    }
    else
    {
      Move( aLevel, 120.0f * ElapsedTime, 0.0f, Dobbs::DIR_RIGHT );
    }
  }

}